#version 330 compatibility

layout(triangles) in;
layout(triangle_strip, max_vertices = 6) out;

in vec4 vcolor[];
in vec4 vtexcoord[];
in vec3 vnormal[];
in vec3 vrawNormal[];
in vec4 vviewPos[];
in float vmaterialIDs[];
in vec4 ENeOnQMIlL[];
in vec4 nMvZxqPPtV[];
in float CGwSTOuNYZ[];
in vec2 XtLqUXvGkQ[];
in float uNvlzPTXWM[];
in float vIsWater[];
in float vIsStainedGlass[];
in float vMCEntity[];

out vec4 color;
out vec4 texcoord;
out vec3 normal;
out vec3 rawNormal;
out vec4 viewPos;
out float materialIDs;

out float ERyeFPBukd;		
out vec2 CXLkCPvGjd;		
out float fragDepth;
out float isWater;
out float isStainedGlass;
out float mcEntity;


void main()
{
	int i;
	vec4 vertex;

	//Standard shadow pos
	for (i = 0; i < 3; i++)
	{
		vertex = gl_in[1].gl_Position;

		//...
		vertex = nMvZxqPPtV[i];

		gl_Position = vertex;

		//copy varying here
		color = vcolor[i];
		texcoord = vtexcoord[i];
		normal = vnormal[i];
		rawNormal = vrawNormal[i];
		viewPos = vviewPos[i];
		materialIDs = vmaterialIDs[i];
		CXLkCPvGjd = XtLqUXvGkQ[i];
		fragDepth = uNvlzPTXWM[i];
		isWater = vIsWater[i];
		isStainedGlass = vIsStainedGlass[i];
		mcEntity = vMCEntity[i];
		ERyeFPBukd = 0.0;

		EmitVertex();
	}
	EndPrimitive();


	//volume pos
	bool valid = true;
	if (CGwSTOuNYZ[0] > 0.5 || CGwSTOuNYZ[1] > 0.5 || CGwSTOuNYZ[2] > 0.5)
	{
		valid = false;
	}

	if (valid)
	{
		if (distance(ENeOnQMIlL[0].xy, ENeOnQMIlL[1].xy) > 1.0 / 1024.0 ||
			distance(ENeOnQMIlL[0].xy, ENeOnQMIlL[2].xy) > 1.0 / 1024.0 ||
			distance(ENeOnQMIlL[1].xy, ENeOnQMIlL[2].xy) > 1.0 / 1024.0)
		{

		}
		else
		{
			for (i = 0; i < 3; i++)
			{
				vertex = gl_in[1].gl_Position;

				//...
				vertex = ENeOnQMIlL[i];


				gl_Position = vertex;

				//copy varying here
				color = vcolor[i];
				texcoord = vtexcoord[i];
				normal = vnormal[i];
				rawNormal = vrawNormal[i];
				viewPos = vviewPos[i];
				materialIDs = vmaterialIDs[i];
				CXLkCPvGjd = XtLqUXvGkQ[i];
				fragDepth = uNvlzPTXWM[i];
				isWater = vIsWater[i];
				isStainedGlass = vIsStainedGlass[i];
				mcEntity = vMCEntity[i];
				ERyeFPBukd = 1.0;


				EmitVertex();
			}
			EndPrimitive();
		}
	}


	// vec4 bottomLeft = 	vec4(-1.0, 	0.0, 	0.0, 1.0);
	// vec4 bottomRight = 	vec4(0.0, 	0.0, 	0.0, 1.0);
	// vec4 topLeft = 		vec4(-1.0, 	1.0,    0.0, 1.0);
	// vec4 topRight = 	vec4(0.0, 	1.0,    0.0, 1.0);

	// //Albedo quad
	// color = vec4(1.0);
	// normal = vec3(1.0);
	// rawNormal = vec3(1.0);
	// viewPos = vec4(0.0);
	// materialIDs = 1.0;
	// isStainedGlass = 0.0;
	// ERyeFPBukd = 0.0;

	// texcoord = vec4(0.0, 0.0, 0.0, 0.0);
	// gl_Position = bottomLeft;

	// EmitVertex();


	// texcoord = vec4(0.0, 1.0, 0.0, 0.0);
	// gl_Position = topLeft;

	// EmitVertex();


	// texcoord = vec4(1.0, 1.0, 0.0, 0.0);
	// gl_Position = topRight;

	// EmitVertex();


	// EndPrimitive();



	// texcoord = vec4(0.0, 0.0, 0.0, 0.0);
	// gl_Position = bottomLeft;

	// EmitVertex();



	// texcoord = vec4(1.0, 1.0, 0.0, 0.0);
	// gl_Position = topRight;

	// EmitVertex();



	// texcoord = vec4(1.0, 0.0, 0.0, 0.0);
	// gl_Position = bottomRight;

	// EmitVertex();


	// EndPrimitive();



}
